define(['angular', 'app', 'moment'], function (angular, app, moment) {
	'use strict';
	app.controller('AssessmentBuilderEditController', function ($scope, $modal, $location, $state, $stateParams, globalDelayTracker, previousState, focusService, modalService, assessmentService) {
		function loadData(assessment) {
			$scope.assessment = assessment; 
			$scope.lastModifiedDate = new Date($scope.assessment.lastModifiedDate);
			if(assessment.status == "Active") {
				$scope.globalDelayTracker.add('checkAssessment');
				$scope.disableModify = false; 
				assessmentService.getAssessments().then(function(response) {
					for(var index in response.data.assessment) {
						var assessment = response.data.assessment[index];
						if(assessment.uniqueTitle == $scope.assessment.uniqueTitle && assessment.version == $scope.assessment.version + 1) {
							$scope.disableModify = true; 
							break; 
						}
					}
					$scope.globalDelayTracker.remove('checkAssessment'); 
				}); 
			}

		}

		$scope.assessment = assessmentService.getBlankAssessment();
		$scope.titleRegex = new RegExp("^.*$");
		$scope.globalDelayTracker = globalDelayTracker;

		if($stateParams.assessment) {	//If provided from previous state, use it.
			loadData($stateParams.assessment);
		} else if($stateParams.id) {	//If page was refreshed, try to refetch the assessment
			$scope.globalDelayTracker.add('getAssessment');
			$scope.initializing = true;
			assessmentService.getAssessmentById($stateParams.id).then(function(response) {
				if(response.status == 200) {
					loadData(response.data); 
				} else if(response.status == 204) {
					$state.go($state.current, {id: null}, {reload: true}); 
				}
				$scope.globalDelayTracker.remove('getAssessment');
				$scope.initializing = false; 
			}, function(response) {
				$state.go($state.current, {id: null}, {reload: true}); 
			});
		} else {						//Else create a new assessment
			$scope.assessment.createdDate = moment().format('MM/DD/YYYY HH:mm:ss');
			$scope.assessment.lastModifiedDate = moment().format('MM/DD/YYYY HH:mm:ss');
			$scope.lastModifiedDate = new Date($scope.assessment.lastModifiedDate);
		}
		
		var stopWatch = $scope.$watch('globalDelayTracker.active()', function(newValue, oldValue) {
			focusService.focusMain();
			previousState.isFirstAppRoute = false;
			stopWatch();
		});

		$scope.addQuestion = function() {
			$scope.assessment.question.push({
				questionType: undefined
			});
			$scope.$apply(); 
			focusService.focusElement(angular.element('div[group-id=question-accordion-'+ ($scope.assessment.question.length) + '] .panel-heading'), false);
		};
		$scope.changeQuestion = function(type, index) {
			if(type) {
				var questionModel = { 
					questionType: type,
				};
				$scope.assessment.question[index] = $.extend(assessmentService.getModel(type), questionModel); 
			} else {
				$scope.assessment.question[index] = {questionType: undefined};
			}
		};
		$scope.removeQuestion = function(index) {
			var modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: 'src/modules/assessment-builder/pages/edit-modals/delete-question-modal_template.html',
				controller: 'DeleteQuestionModalController',
				resolve: {
					index: function() {
						return parseInt(index) + 1;
					}
				}
			});
			modalInstance.result.then(function () {
				$scope.assessment.question.splice(index, 1); 
				focusService.focusElement(angular.element('#save-btn'));
			}, function() {
				focusService.focusElement(angular.element('#delete-aa-' + index));
			});
		};
		$scope.updateSliderAtIndex = function(index, value) {
			$scope.assessment.question[index].questionProperties[1].value = value;
		}; 
		$scope.questionTypeOptions = [
			{label: 'Yes/No', value: 'yesNo'},
			{label: 'Single Select – one answer can be selected', value: 'singleSelect'},
			{label: 'Multi Select – can select multiple answers', value: 'multiSelect'},
			{label: 'Slider – pick a number on a scale', value: 'slider'},
			{label: 'Text', value: 'text'}
		];

		$scope.openInstructionsModal = function () {
			var modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: 'src/modules/assessment-builder/pages/edit-modals/assessment-description-modal_template.html',
				controller: 'AssessmentDescriptionModalController'
			});
			modalInstance.result.finally(function () {
				focusService.focusElement(angular.element('#instructions-link'));
			});
		};

		$scope.openMyVAHealthModal = function() {
			modalService.showModal({}, {
				actionButtonText: 'OK',
				headerText: 'Display in My VA Health Information',
				bodyText: 'Checking Display in My VA Health will make this Assessment available for display in My VA Health'
			}).then(function () {
				focusService.focusElement(angular.element('#in-health-assessment-help'));
			});
		}; 

		$scope.delete = function() {
			var modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: 'src/modules/assessment-builder/pages/edit-modals/delete-assessment-modal_template.html',
				controller: 'DeleteAssessmentModalController',
				resolve: {
					assessment: function() {
						return $scope.assessment;
					}
				}
			});
			modalInstance.result.then(function () {
				assessmentService.deleteAssessment($scope.assessment.id).then(function() {
					modalService.showModal({}, {
						actionButtonText: 'OK',
						headerText: 'Deletion Successful',
						bodyText: 'The draft assessment has been successfully deleted.'
					}).then(function () {
						$state.go('^.list');
					});
				});
			}, function() {
				focusService.focusElement(angular.element('#delete-btn'));
			});
		};

		$scope.save = function(formCtrl) {
			$scope.assessment.uniqueTitle = $scope.assessment.uniqueTitle.trim();
			formCtrl.validationSummary.validate();
			if(formCtrl.$valid) {
				$scope.assessment.lastModifiedDate = moment().format('MM/DD/YYYY HH:mm:ss');
				assessmentService.saveAssessment($scope.assessment).then(function(response) {
					$scope.assessment = response.data;
					if(!$stateParams.id) {	//Guard to keep user on the created assessment if page refreshed
						$stateParams.id = $scope.assessment.id;
						$location.path($location.path() + $scope.assessment.id);
					}
					formCtrl.$setPristine();
					modalService.showModal({}, {
						actionButtonText: 'OK',
						headerText: 'Assessment Saved',
						bodyText: 'Assessment was successfully saved'
					}).then(function () {
						focusService.focusElement(angular.element('#save-btn'));
					});
				}, function(response) {
					if(response.data.errorMessage.indexOf("record exists") !== -1) {
						$scope.titleRegex = new RegExp("^(?!\\s*" + $scope.assessment.uniqueTitle + "\\s*$).*$");
						formCtrl.validationSummary.validate();
					} else {
						//Some other error happened
					}
				}); 
			}
		};

		function attemptPublish() {
			var modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: 'src/modules/assessment-builder/pages/edit-modals/publish-assessment-modal_template.html',
				controller: 'PublishAssessmentModalController',
				resolve: {
					assessment: function() {
						return $scope.assessment;
					}
				}
			});
			modalInstance.result.then(function () {
				$scope.assessment.publish = true;
				$scope.assessment.lastModifiedDate = moment().format('MM/DD/YYYY HH:mm:ss');
				assessmentService.saveAssessment($scope.assessment).then(function() {
					modalService.showModal({}, {
						actionButtonText: 'OK',
						headerText: 'Publication Successful',
						bodyText: 'Your assessment has been successfully published.'
					}).then(function () {
						$state.go('^.list');
					});
				});
			}, function() {
				focusService.focusElement(angular.element('#publish-btn'));
			});
		}

		$scope.publish = function(formCtrl) {
			if($scope.assessment.question.length > 0) {
				formCtrl.validationSummary.validate();
				if(formCtrl.$valid) {
					if(formCtrl.$dirty) {
						modalService.showModal({}, {
							actionButtonText: 'Save and Publish',
							closeButtonText: 'Continue Editing',
							headerText: 'Save Changes',
							bodyText: 'You have modified this assessment since it was last saved. All changes must be saved before an assessment can be published.'
						}).then(function () {
							$scope.assessment.lastModifiedDate = moment().format('MM/DD/YYYY HH:mm:ss');
							assessmentService.saveAssessment($scope.assessment).then(function(response) {
								formCtrl.$setPristine();
								attemptPublish(); 
							}); 
						}, function() {
							focusService.focusElement(angular.element('#publish-btn'));
						});
					} else {
						attemptPublish();
					}
				}
			} else {
				//Push a 'special' kind of error that doesn't relate to an input field
				formCtrl.validationSummary.validate().then(function() {
					formCtrl.validationSummary.pushError('A minimum of one question is required.'); 
					focusService.focusElement('.validation-summary h5');
				}, function() {
					formCtrl.validationSummary.pushError('A minimum of one question is required.'); 
				});
			}
		};

		$scope.inactivate = function() {
			var modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: 'src/modules/assessment-builder/pages/edit-modals/inactivate-assessment-modal_template.html',
				controller: 'InactivateAssessmentModalController',
				resolve: {
					assessment: function() {
						return $scope.assessment;
					}
				}
			});
			modalInstance.result.then(function () {
				assessmentService.inactivateAssessment($scope.assessment.id).then(function() {
					modalService.showModal({}, {
						actionButtonText: 'OK',
						headerText: 'Inactivation Successful',
						bodyText: 'The assessment has been successfully inactivated.'
					}).then(function () {
						$state.go('^.list');
					});
				});
			}, function() {
				focusService.focusElement(angular.element('#inactive-btn'));
			});
		};

		$scope.modify = function() {
			var modalInstance = $modal.open({
				windowTemplateUrl: 'src/ui-components/modals/helper/modal-window_template.html',
				templateUrl: 'src/modules/assessment-builder/pages/edit-modals/modify-assessment-modal_template.html',
				controller: 'ModifyAssessmentModalController',
				resolve: {
					assessment: function() {
						return $scope.assessment;
					}
				}
			});
			modalInstance.result.then(function () {
				$scope.assessment.lastModifiedDate = moment().format('MM/DD/YYYY HH:mm:ss');
				assessmentService.modifyAssessment($scope.assessment).then(function(response) {
					$state.go($state.current, {assessment: response.data, id: response.data.id}, {reload: true});
				});
			}, function() {
				focusService.focusElement(angular.element('#modify-btn'));
			});
		};
	});
});